/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.tigris.atlas.transfer.PrimaryKey;
import org.tigris.atlas.transfer.TransferObject;

import gov.va.med.mhv.core.util.DescriptionBuilder;
import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.PatientRegistryChange;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;


/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class RegistryDescriptionBuilder extends
    gov.va.med.mhv.core.util.DescriptionBuilder
{

    private static ArrayList<Appender> DEFAULT_APPENDERS = createAppenders();

    private static ArrayList<Appender> createAppenders() {
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        appenders.add(new PatientRegistryChangeAppender());
        appenders.add(new PatientAppender());
        appenders.add(new UserProfileAppender());
        return appenders;
    }

    @SuppressWarnings("unchecked")
    private static final List<Appender> getDefaultAppenders() {
        return (List<Appender>) DEFAULT_APPENDERS.clone(); // unchecked
    }

    /**
     * Convenience method that uses a standard DescriptionBuilder to build 
     * a description of the given object.
     * <pre>
     *     return new DescriptionBuilder().append(value).toString();
     * </pre>
     * @param value The object to describe.
     */
    public static String describe(Object value) {
        return new RegistryDescriptionBuilder().append(value).toString();
    }

    /**
     * 
     */
    public RegistryDescriptionBuilder() {
        super();
        addAppenders(getDefaultAppenders());
    }

    /**
     * @param arg0
     */
    public RegistryDescriptionBuilder(Properties properties) {
        super(properties);
        addAppenders(getDefaultAppenders());
    }

    private static abstract class BaseAppender extends Appender {
        
        public BaseAppender(Class clazz) {
            super(clazz);
        }
        
        protected void header(DescriptionBuilder builder, 
            TransferObject value) 
        { 
            if (builder == null) {
                return;
            }
            Precondition.assertNotNull("value", value);
            appendString(builder, StringUtils.substringAfterLast(value.
                getClass().getName(), "."));
             PrimaryKey key = value.getKey();
             if (key != null) {
                 appendString(builder, "@(id=");
                 builder.append(key.getValue());
                 appendString(builder, ")");
             }
        }

        protected void append(DescriptionBuilder builder, 
            UserProfile userProfile) 
        {
            if (userProfile == null) {
                return;
            }
            appendProperty(builder, "firstName", userProfile.getFirstName());
            appendProperty(builder, "middleName", userProfile.getFirstName());
            appendProperty(builder, "lastName", userProfile.getLastName());
            appendProperty(builder, "DOB", userProfile.getBirthDate());
            appendProperty(builder, "ssn", "***-**-" + StringUtils.substring(
                userProfile.getSsn(), 5));
            appendProperty(builder, "gender", userProfile.getGender());
        }

        protected List<String> getStationNumbers(Collection facilities) {
            List<String> stationNumbers = new ArrayList<String>();
            if (facilities != null) {
                for (Object o: facilities) {
                    stationNumbers.add(((Facility) o).getName());
                }
            }
            return stationNumbers;
            
        }
        
    }

    private static class PatientAppender extends BaseAppender {
        
        public PatientAppender() {
            super(Patient.class);
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        @Override
        public void append(gov.va.med.mhv.core.util.DescriptionBuilder builder, 
            Object value) 
        {
            Patient patient = (Patient) value;
            header(builder, patient);
            openPropertyList(builder);
            appendProperty(builder, "id", patient.getId(), true);
            append(builder, patient.getUserProfile());
            appendProperty(builder, "icn", patient.getIcn());
            appendProperty(builder, "facilities", getStationNumbers(patient.
                getFacilitys()));
            //appendProperty(builder, "registryChanges", patient.
            //    getPatientRegistryChanges());
            closePropertyList(builder);
        }
        
    }

    private static class UserProfileAppender extends BaseAppender {
        
        public UserProfileAppender() {
            super(UserProfile.class);
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        @Override
        public void append(gov.va.med.mhv.core.util.DescriptionBuilder builder, 
            Object value) 
        {
            UserProfile userprofile = (UserProfile) value;
            header(builder, userprofile);
            openPropertyList(builder);
            append(builder, userprofile);
            closePropertyList(builder);
        }
        
    }

    private static class PatientRegistryChangeAppender extends BaseAppender {
        
        public PatientRegistryChangeAppender() {
            super(PatientRegistryChange.class);
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        @Override
        public void append(gov.va.med.mhv.core.util.DescriptionBuilder builder, 
            Object value) 
        {
            PatientRegistryChange change = (PatientRegistryChange) value;
            header(builder, change);
            openPropertyList(builder);
            appendProperty(builder, "recordOn", change.getRecordedOnDate(), 
                true);
            appendProperty(builder, "oldIcn", change.getOldIcn());
            appendProperty(builder, "oldFacilityCount", change.
                getOldFacilityCount());
            appendProperty(builder, "oldFirstName", change.getOldFirstName());
            appendProperty(builder, "oldMiddleName", change.getOldLastName());
            appendProperty(builder, "oldLastName", change.getOldLastName());
            appendProperty(builder, "oldBirthDate", change.getOldBirthDate());
            appendProperty(builder, "oldSsn", change.getOldSsn());
            appendProperty(builder, "oldGender", change.getOldGender());
            closePropertyList(builder);
        }
    }
}
